#include <stdlib.h>
#include <stdio.h>

void SwapL (long* x, long* y)
{
    long t = *x;
    *x = *y;
    *y = t;
}

void SwapD (double* x, double* y)
{
    double t = *x;
    *x = *y;
    *y = t;
}

void Sort (long* A, double* P, long l, long r)
{
    if (l<r)
    {
        double piv = P[r];
        long i = l-1;
        for (long j=l; j<r; j++)
            if (P[j]>piv)
            {
                i++;
                SwapL (&A[i], &A[j]);
                SwapD (&P[i], &P[j]);
            }
        SwapL (&A[i+1], &A[r]);
        SwapD (&P[i+1], &P[r]);

        Sort (A, P, l, i);
        Sort (A, P, i+2, r);
    }
}

int main()
{
    long N;
    scanf ("%ld", &N);

    long* A = (long*)malloc (N*sizeof (long));
    double* P = (double*)malloc (N*sizeof (double));
    for (long i=0; i<N; i++)
        scanf ("%ld %lf/n", &A[i], &P[i]);

    Sort (A, P, 0, N-1);

    double cur = A[0]*P[0];
    double Max = cur;

    for (long i=1; i<N; i++)
    {
        cur = (cur/P[i-1]+A[i])*P[i];
        if (cur>Max)
            Max = cur;
    }

    printf ("%.5lf", Max/100);

    return 0;
}